/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import com.work4games.main.Game;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;

public class MenuState
extends GameState {
    private int currentChoice = 0;
    private String[] options = new String[]{"Game Start", "Exit Game"};

    public MenuState(GameStateManager gsm) {
        this.gsm = gsm;
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.BlueSky, 0, 0, null);
        g.setFont(this.gsm.font);
        g.setColor(Color.WHITE);
        this.gsm.drawCenteredString("Pixel Match", 320, 100, g);
        int i = 0;
        while (i < this.options.length) {
            if (i == this.currentChoice) {
                g.setColor(Color.YELLOW);
            } else {
                g.setColor(Color.WHITE);
            }
            this.gsm.drawCenteredString(this.options[i], 320, 240 + i * 30, g);
            ++i;
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            this.gsm.setState(1);
        }
        if (currentChoice == 1) {
            System.exit(0);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ENTER)) {
            this.select(this.currentChoice);
        }
        if (Keys.isKeyPressed(Keys.UP)) {
            this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
        }
        if (Keys.isKeyPressed(Keys.DOWN)) {
            this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
        }
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            Game.loading = true;
            System.exit(0);
        }
    }
}

